package editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class NewRoomSetupWizard extends JPanel implements NewRoomData {
	
	
	private Window encasingFrame;
	private boolean isCancelled;
	
	private JTextField tileWidthField;
	private JTextField tileHeightField;
	private JTextField roomWidthField;
	private JTextField roomHeightField;
	
	private JTextField backgroundField;
	private JTextField foregroundField;
	
	
	private int tileWidth;
	private int tileHeight;
	private int roomWidth;
	private int roomHeight;
	
	private String backgroundImageName;
	private String foregroundImageName;
	
	private SharedColor unusedColor;
	private SharedColor transparentColor;
	private SharedColor outOfBoundsColor;
	
	private MicroColorCanvas unusedColorCanvas;
	private MicroColorCanvas transparentColorCanvas;
	private MicroColorCanvas outOfBoundsColorCanvas;
	
	private JTextField nameField;
	
	private String roomName;
	private String oldName;
	
	private RoomEditorPanel roomPanel;
	
	private JPanel encaseInFlowLayout(Component c) {
		JPanel returnValue = new JPanel();
		returnValue.setLayout(new FlowLayout());
		returnValue.add(c);
		return returnValue;
	}
	
	private JPanel encaseInBorderLayout(Component c) {
		JPanel returnValue = new JPanel();
		returnValue.setLayout(new BorderLayout());
		returnValue.add(c, BorderLayout.CENTER);
		return returnValue;
	}
	
	private MainEditorPanel mainPanel;
	
	
	public NewRoomSetupWizard(JFrame theFrame, MainEditorPanel theMainPanel) {
		
		encasingFrame = theFrame;
		theFrame.setTitle("New Room");
		isCancelled = true;
		mainPanel = theMainPanel;
		oldName = null;
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
		
		
		
		JPanel upperHalf = new JPanel();
		upperHalf.setLayout(new BoxLayout(upperHalf, BoxLayout.X_AXIS));
		
		
		JPanel tileDimensions = new JPanel();
		tileDimensions.setLayout(new BoxLayout(tileDimensions, BoxLayout.Y_AXIS));
		
		JPanel tileX = new JPanel();
		tileX.setLayout(new FlowLayout());
		JLabel tileXLabel = new JLabel("tile width: ");
		tileWidthField = new JTextField(5);
		tileX.add(tileXLabel);
		tileX.add(tileWidthField);
		tileDimensions.add(tileX);
		
		JPanel tileY = new JPanel();
		tileY.setLayout(new FlowLayout());
		JLabel tileYLabel = new JLabel("tile height: ");
		tileHeightField = new JTextField(5);
		tileY.add(tileYLabel);
		tileY.add(tileHeightField);
		tileDimensions.add(tileY);
		
		JPanel unusedColorPanel = new JPanel();
		unusedColorPanel.setLayout(new FlowLayout());
		unusedColorPanel.add(new JLabel("unused color: "));
		unusedColor = new SharedColor();
		unusedColorCanvas = new MicroColorCanvas(unusedColor);
		unusedColorPanel.add(unusedColorCanvas);
		JButton unusedColorButton = new JButton("Change...");
		unusedColorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(unusedColor, unusedColorCanvas);
			}
		});
		unusedColorPanel.add(unusedColorButton);
		
		tileDimensions.add(unusedColorPanel);
		
		
		upperHalf.add(tileDimensions);
		
		
		
		JPanel roomDimensions = new JPanel();
		roomDimensions.setLayout(new BoxLayout(roomDimensions, BoxLayout.Y_AXIS));
		
		JPanel roomWidth = new JPanel();
		roomWidth.setLayout(new FlowLayout());
		JLabel roomWidthLabel = new JLabel("total room width (in tiles): ");
		roomWidthField = new JTextField(5);
		roomWidth.add(roomWidthLabel);
		roomWidth.add(roomWidthField);
		roomDimensions.add(roomWidth);
		
		JPanel roomHeight = new JPanel();
		roomHeight.setLayout(new FlowLayout());
		JLabel roomHeightLabel = new JLabel("total room height (in tiles): ");
		roomHeightField = new JTextField(5);
		roomHeight.add(roomHeightLabel);
		roomHeight.add(roomHeightField);
		roomDimensions.add(roomHeight);

		JPanel outOfBoundsPanel = new JPanel();
		outOfBoundsPanel.setLayout(new FlowLayout());
		outOfBoundsPanel.add(new JLabel("room out-of-bounds color: "));
		outOfBoundsColor = new SharedColor();
		outOfBoundsColorCanvas = new MicroColorCanvas(outOfBoundsColor);
		outOfBoundsPanel.add(outOfBoundsColorCanvas);
		JButton outOfBoundsButton = new JButton("Change...");
		outOfBoundsButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(outOfBoundsColor, outOfBoundsColorCanvas);
			}
		});
		outOfBoundsPanel.add(outOfBoundsButton);
		
		
		
		
		roomDimensions.add(outOfBoundsPanel);
		
		
		
		
		upperHalf.add(roomDimensions);
		
		
		
		
		JPanel lowerHalf = new JPanel();
		lowerHalf.setLayout(new BoxLayout(lowerHalf, BoxLayout.Y_AXIS));
		
		JPanel transparentColorPanel = new JPanel();
		transparentColorPanel.setLayout(new FlowLayout());
		transparentColorPanel.add(new JLabel("foreground image transparent color: "));
		transparentColor = new SharedColor();
		transparentColorCanvas = new MicroColorCanvas(transparentColor);
		transparentColorPanel.add(transparentColorCanvas);
		JButton transparentColorButton = new JButton("Change...");
		transparentColorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(transparentColor, transparentColorCanvas);
			}
		});
		transparentColorPanel.add(transparentColorButton);
		
		lowerHalf.add(transparentColorPanel);
		
		
		JPanel background = new JPanel();
		background.setLayout(new BoxLayout(background, BoxLayout.X_AXIS));
		JLabel backgroundLabel = new JLabel("background image:");
		backgroundField = new JTextField(200);
		Border backgroundFieldBorder = BorderFactory.createBevelBorder(BevelBorder.LOWERED);
		backgroundField.setHorizontalAlignment(JTextField.CENTER);
		backgroundField.setBorder(backgroundFieldBorder);
//		backgroundField.setMinimumSize(new Dimension(100, 25));
//		backgroundField.setMaximumSize(new Dimension(100, 25));
//		backgroundField.setPreferredSize(new Dimension(100, 25));
		backgroundField.setEditable(false);
		JButton backgroundButton = new JButton("Browse...");
		backgroundButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				retrieveImageFile(backgroundField, encasingFrame);
			}
		});
		background.add(encaseInFlowLayout(backgroundLabel));
		background.add(encaseInFlowLayout(backgroundField));
		background.add(encaseInFlowLayout(backgroundButton));
		
		JPanel foreground = new JPanel();
		foreground.setLayout(new BoxLayout(foreground, BoxLayout.X_AXIS));
		JLabel foregroundLabel = new JLabel("foreground image:");
		foregroundField = new JTextField(200);
		Border foregroundFieldBorder = BorderFactory.createBevelBorder(BevelBorder.LOWERED);
		foregroundField.setHorizontalAlignment(JTextField.CENTER);
		foregroundField.setBorder(foregroundFieldBorder);
//		foregroundField.setMinimumSize(new Dimension(100, 25));
//		foregroundField.setMaximumSize(new Dimension(100, 25));
//		foregroundField.setPreferredSize(new Dimension(100, 25));
		foregroundField.setEditable(false);
		JButton foregroundButton = new JButton("Browse...");
		foregroundButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				retrieveImageFile(foregroundField, encasingFrame);
			}
		});
		foreground.add(encaseInFlowLayout(foregroundLabel));
		foreground.add(encaseInFlowLayout(foregroundField));
		foreground.add(encaseInFlowLayout(foregroundButton));
		
		lowerHalf.add(background);
		lowerHalf.add(foreground);
		
		
		JPanel namePanel = new JPanel();
		namePanel.setLayout(new FlowLayout());
		JLabel nameLabel = new JLabel("Room Name: ");
		nameField = new JTextField(30);
		namePanel.add(nameLabel);
		namePanel.add(nameField);
		
		lowerHalf.add(namePanel);
		
		
		
		mainPanel.add(upperHalf);
		mainPanel.add(lowerHalf);
		
		
		
		
		
		this.setLayout(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);
		
		JPanel bottomPart = new JPanel();
		bottomPart.setLayout(new GridLayout(1, 4));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				cancelWasClicked();
			}
		});
		bottomPart.add((cancelButton));
		
		bottomPart.add(new JPanel());
		bottomPart.add(new JPanel());
//		bottomPart.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				okWasClicked();
			}
		});
		bottomPart.add((okButton));
		
		this.add(bottomPart, BorderLayout.SOUTH);
	}
	
	

	public NewRoomSetupWizard(JDialog theFrame, MainEditorPanel theMainPanel) {
		
		encasingFrame = theFrame;
		theFrame.setTitle("New Room");
		isCancelled = true;
		mainPanel = theMainPanel;
		oldName = null;
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
		
		
		
		JPanel upperHalf = new JPanel();
		upperHalf.setLayout(new BoxLayout(upperHalf, BoxLayout.X_AXIS));
		
		
		JPanel tileDimensions = new JPanel();
		tileDimensions.setLayout(new BoxLayout(tileDimensions, BoxLayout.Y_AXIS));
		
		JPanel tileX = new JPanel();
		tileX.setLayout(new FlowLayout());
		JLabel tileXLabel = new JLabel("tile width: ");
		tileWidthField = new JTextField(5);
		tileX.add(tileXLabel);
		tileX.add(tileWidthField);
		tileDimensions.add(tileX);
		
		JPanel tileY = new JPanel();
		tileY.setLayout(new FlowLayout());
		JLabel tileYLabel = new JLabel("tile height: ");
		tileHeightField = new JTextField(5);
		tileY.add(tileYLabel);
		tileY.add(tileHeightField);
		tileDimensions.add(tileY);
		
		JPanel unusedColorPanel = new JPanel();
		unusedColorPanel.setLayout(new FlowLayout());
		unusedColorPanel.add(new JLabel("unused color: "));
		unusedColor = new SharedColor();
		unusedColorCanvas = new MicroColorCanvas(unusedColor);
		unusedColorPanel.add(unusedColorCanvas);
		JButton unusedColorButton = new JButton("Change...");
		unusedColorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(unusedColor, unusedColorCanvas);
			}
		});
		unusedColorPanel.add(unusedColorButton);
		
		tileDimensions.add(unusedColorPanel);
		
		
		upperHalf.add(tileDimensions);
		
		
		
		JPanel roomDimensions = new JPanel();
		roomDimensions.setLayout(new BoxLayout(roomDimensions, BoxLayout.Y_AXIS));
		
		JPanel roomWidth = new JPanel();
		roomWidth.setLayout(new FlowLayout());
		JLabel roomWidthLabel = new JLabel("total room width (in tiles): ");
		roomWidthField = new JTextField(5);
		roomWidth.add(roomWidthLabel);
		roomWidth.add(roomWidthField);
		roomDimensions.add(roomWidth);
		
		JPanel roomHeight = new JPanel();
		roomHeight.setLayout(new FlowLayout());
		JLabel roomHeightLabel = new JLabel("total room height (in tiles): ");
		roomHeightField = new JTextField(5);
		roomHeight.add(roomHeightLabel);
		roomHeight.add(roomHeightField);
		roomDimensions.add(roomHeight);

		JPanel outOfBoundsPanel = new JPanel();
		outOfBoundsPanel.setLayout(new FlowLayout());
		outOfBoundsPanel.add(new JLabel("room out-of-bounds color: "));
		outOfBoundsColor = new SharedColor();
		outOfBoundsColorCanvas = new MicroColorCanvas(outOfBoundsColor);
		outOfBoundsPanel.add(outOfBoundsColorCanvas);
		JButton outOfBoundsButton = new JButton("Change...");
		outOfBoundsButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(outOfBoundsColor, outOfBoundsColorCanvas);
			}
		});
		outOfBoundsPanel.add(outOfBoundsButton);
		
		
		
		
		roomDimensions.add(outOfBoundsPanel);
		
		
		
		
		upperHalf.add(roomDimensions);
		
		
		
		
		JPanel lowerHalf = new JPanel();
		lowerHalf.setLayout(new BoxLayout(lowerHalf, BoxLayout.Y_AXIS));
		
		JPanel transparentColorPanel = new JPanel();
		transparentColorPanel.setLayout(new FlowLayout());
		transparentColorPanel.add(new JLabel("foreground image transparent color: "));
		transparentColor = new SharedColor();
		transparentColorCanvas = new MicroColorCanvas(transparentColor);
		transparentColorPanel.add(transparentColorCanvas);
		JButton transparentColorButton = new JButton("Change...");
		transparentColorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(transparentColor, transparentColorCanvas);
			}
		});
		transparentColorPanel.add(transparentColorButton);
		
		lowerHalf.add(transparentColorPanel);
		
		
		JPanel background = new JPanel();
		background.setLayout(new BoxLayout(background, BoxLayout.X_AXIS));
		JLabel backgroundLabel = new JLabel("background image:");
		backgroundField = new JTextField(200);
		Border backgroundFieldBorder = BorderFactory.createBevelBorder(BevelBorder.LOWERED);
		backgroundField.setHorizontalAlignment(JTextField.CENTER);
		backgroundField.setBorder(backgroundFieldBorder);
//		backgroundField.setMinimumSize(new Dimension(100, 25));
//		backgroundField.setMaximumSize(new Dimension(100, 25));
//		backgroundField.setPreferredSize(new Dimension(100, 25));
		backgroundField.setEditable(false);
		JButton backgroundButton = new JButton("Browse...");
		backgroundButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				retrieveImageFile(backgroundField, encasingFrame);
			}
		});
		background.add(encaseInFlowLayout(backgroundLabel));
		background.add(encaseInFlowLayout(backgroundField));
		background.add(encaseInFlowLayout(backgroundButton));
		
		JPanel foreground = new JPanel();
		foreground.setLayout(new BoxLayout(foreground, BoxLayout.X_AXIS));
		JLabel foregroundLabel = new JLabel("foreground image:");
		foregroundField = new JTextField(200);
		Border foregroundFieldBorder = BorderFactory.createBevelBorder(BevelBorder.LOWERED);
		foregroundField.setHorizontalAlignment(JTextField.CENTER);
		foregroundField.setBorder(foregroundFieldBorder);
//		foregroundField.setMinimumSize(new Dimension(100, 25));
//		foregroundField.setMaximumSize(new Dimension(100, 25));
//		foregroundField.setPreferredSize(new Dimension(100, 25));
		foregroundField.setEditable(false);
		JButton foregroundButton = new JButton("Browse...");
		foregroundButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				retrieveImageFile(foregroundField, encasingFrame);
			}
		});
		foreground.add(encaseInFlowLayout(foregroundLabel));
		foreground.add(encaseInFlowLayout(foregroundField));
		foreground.add(encaseInFlowLayout(foregroundButton));
		
		lowerHalf.add(background);
		lowerHalf.add(foreground);
		
		
		JPanel namePanel = new JPanel();
		namePanel.setLayout(new FlowLayout());
		JLabel nameLabel = new JLabel("Room Name: ");
		nameField = new JTextField(30);
		namePanel.add(nameLabel);
		namePanel.add(nameField);
		
		lowerHalf.add(namePanel);
		
		
		
		mainPanel.add(upperHalf);
		mainPanel.add(lowerHalf);
		
		
		
		
		
		this.setLayout(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);
		
		JPanel bottomPart = new JPanel();
		bottomPart.setLayout(new GridLayout(1, 4));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				cancelWasClicked();
			}
		});
		bottomPart.add((cancelButton));
		
		bottomPart.add(new JPanel());
		bottomPart.add(new JPanel());
//		bottomPart.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				okWasClicked();
			}
		});
		bottomPart.add((okButton));
		
		this.add(bottomPart, BorderLayout.SOUTH);
	}
	
	
	
	
	public NewRoomSetupWizard(JDialog theFrame,
			  				  int origTileWidth,
			  				  int origTileHeight,
			  				  int origRoomWidth,
			  				  int origRoomHeight,
			  				  Color origUnusedColor,
			  				  Color origTransparentColor,
			  				  Color origOutOfBoundsColor,
			  				  String origBackgroundFileName,
			  				  String origForegroundFileName,
			  				  String origRoomName,
			  				  MainEditorPanel theMainPanel,
			  				  RoomEditorPanel theRoomPanel) {
		
		encasingFrame = theFrame;
		isCancelled = true;
		oldName = origRoomName;
		mainPanel = theMainPanel;
		roomPanel = theRoomPanel;
		theFrame.setTitle("Editing background and dimensions of room: " + oldName);
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
		
		
		
		JPanel upperHalf = new JPanel();
		upperHalf.setLayout(new BoxLayout(upperHalf, BoxLayout.X_AXIS));
		
		
		JPanel tileDimensions = new JPanel();
		tileDimensions.setLayout(new BoxLayout(tileDimensions, BoxLayout.Y_AXIS));
		
		JPanel tileX = new JPanel();
		tileX.setLayout(new FlowLayout());
		JLabel tileXLabel = new JLabel("tile width: ");
		tileWidthField = new JTextField(5);
		tileWidthField.setText(Integer.toString(origTileWidth));
		tileX.add(tileXLabel);
		tileX.add(tileWidthField);
		tileDimensions.add(tileX);
		
		JPanel tileY = new JPanel();
		tileY.setLayout(new FlowLayout());
		JLabel tileYLabel = new JLabel("tile height: ");
		tileHeightField = new JTextField(5);
		tileHeightField.setText(Integer.toString(origTileHeight));
		tileY.add(tileYLabel);
		tileY.add(tileHeightField);
		tileDimensions.add(tileY);
		
		JPanel unusedColorPanel = new JPanel();
		unusedColorPanel.setLayout(new FlowLayout());
		unusedColorPanel.add(new JLabel("unused color: "));
		unusedColor = new SharedColor();
		unusedColor.setColor(origUnusedColor);
		unusedColorCanvas = new MicroColorCanvas(unusedColor);
		unusedColorPanel.add(unusedColorCanvas);
		JButton unusedColorButton = new JButton("Change...");
		unusedColorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(unusedColor, unusedColorCanvas);
			}
		});
		unusedColorPanel.add(unusedColorButton);
		
		tileDimensions.add(unusedColorPanel);
		
		
		upperHalf.add(tileDimensions);
		
		
		
		JPanel roomDimensions = new JPanel();
		roomDimensions.setLayout(new BoxLayout(roomDimensions, BoxLayout.Y_AXIS));
		
		JPanel roomWidth = new JPanel();
		roomWidth.setLayout(new FlowLayout());
		JLabel roomWidthLabel = new JLabel("total room width (in tiles): ");
		roomWidthField = new JTextField(5);
		roomWidthField.setText(Integer.toString(origRoomWidth));
		roomWidth.add(roomWidthLabel);
		roomWidth.add(roomWidthField);
		roomDimensions.add(roomWidth);
		
		JPanel roomHeight = new JPanel();
		roomHeight.setLayout(new FlowLayout());
		JLabel roomHeightLabel = new JLabel("total room height (in tiles): ");
		roomHeightField = new JTextField(5);
		roomHeightField.setText(Integer.toString(origRoomHeight));
		roomHeight.add(roomHeightLabel);
		roomHeight.add(roomHeightField);
		roomDimensions.add(roomHeight);

		JPanel outOfBoundsPanel = new JPanel();
		outOfBoundsPanel.setLayout(new FlowLayout());
		outOfBoundsPanel.add(new JLabel("room out-of-bounds color: "));
		outOfBoundsColor = new SharedColor();
		outOfBoundsColor.setColor(origOutOfBoundsColor);
		outOfBoundsColorCanvas = new MicroColorCanvas(outOfBoundsColor);
		outOfBoundsPanel.add(outOfBoundsColorCanvas);
		JButton outOfBoundsButton = new JButton("Change...");
		outOfBoundsButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(outOfBoundsColor, outOfBoundsColorCanvas);
			}
		});
		outOfBoundsPanel.add(outOfBoundsButton);
		
		
		
		
		roomDimensions.add(outOfBoundsPanel);
		
		
		
		
		upperHalf.add(roomDimensions);
		
		
		
		
		JPanel lowerHalf = new JPanel();
		lowerHalf.setLayout(new BoxLayout(lowerHalf, BoxLayout.Y_AXIS));
		
		JPanel transparentColorPanel = new JPanel();
		transparentColorPanel.setLayout(new FlowLayout());
		transparentColorPanel.add(new JLabel("foreground image transparent color: "));
		transparentColor = new SharedColor();
		transparentColor.setColor(origTransparentColor);
		transparentColorCanvas = new MicroColorCanvas(transparentColor);
		transparentColorPanel.add(transparentColorCanvas);
		JButton transparentColorButton = new JButton("Change...");
		transparentColorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(transparentColor, transparentColorCanvas);
			}
		});
		transparentColorPanel.add(transparentColorButton);
		
		lowerHalf.add(transparentColorPanel);
		
		
		JPanel background = new JPanel();
		background.setLayout(new BoxLayout(background, BoxLayout.X_AXIS));
		JLabel backgroundLabel = new JLabel("background image:");
		backgroundField = new JTextField(200);
		Border backgroundFieldBorder = BorderFactory.createBevelBorder(BevelBorder.LOWERED);
		backgroundField.setHorizontalAlignment(JTextField.CENTER);
		backgroundField.setBorder(backgroundFieldBorder);
//		backgroundField.setMinimumSize(new Dimension(100, 25));
//		backgroundField.setMaximumSize(new Dimension(100, 25));
//		backgroundField.setPreferredSize(new Dimension(100, 25));
		backgroundField.setEditable(false);
		backgroundField.setText(origBackgroundFileName);
		JButton backgroundButton = new JButton("Browse...");
		backgroundButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				retrieveImageFile(backgroundField, encasingFrame);
			}
		});
		background.add(encaseInFlowLayout(backgroundLabel));
		background.add(encaseInFlowLayout(backgroundField));
		background.add(encaseInFlowLayout(backgroundButton));
		
		JPanel foreground = new JPanel();
		foreground.setLayout(new BoxLayout(foreground, BoxLayout.X_AXIS));
		JLabel foregroundLabel = new JLabel("foreground image:");
		foregroundField = new JTextField(200);
		Border foregroundFieldBorder = BorderFactory.createBevelBorder(BevelBorder.LOWERED);
		foregroundField.setHorizontalAlignment(JTextField.CENTER);
		foregroundField.setBorder(foregroundFieldBorder);
//		foregroundField.setMinimumSize(new Dimension(100, 25));
//		foregroundField.setMaximumSize(new Dimension(100, 25));
//		foregroundField.setPreferredSize(new Dimension(100, 25));
		foregroundField.setEditable(false);
		foregroundField.setText(origForegroundFileName);
		JButton foregroundButton = new JButton("Browse...");
		foregroundButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				retrieveImageFile(foregroundField, encasingFrame);
			}
		});
		foreground.add(encaseInFlowLayout(foregroundLabel));
		foreground.add(encaseInFlowLayout(foregroundField));
		foreground.add(encaseInFlowLayout(foregroundButton));
		
		lowerHalf.add(background);
		lowerHalf.add(foreground);
		
		
		JPanel namePanel = new JPanel();
		namePanel.setLayout(new FlowLayout());
		JLabel nameLabel = new JLabel("Room Name: ");
		nameField = new JTextField(30);
		nameField.setText(origRoomName);
		namePanel.add(nameLabel);
		namePanel.add(nameField);
		
		lowerHalf.add(namePanel);
		
		
		
		mainPanel.add(upperHalf);
		mainPanel.add(lowerHalf);
		
		
		
		
		
		this.setLayout(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);
		
		JPanel bottomPart = new JPanel();
		bottomPart.setLayout(new GridLayout(1, 4));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				cancelWasClicked();
			}
		});
		bottomPart.add((cancelButton));
		
		bottomPart.add(new JPanel());
		bottomPart.add(new JPanel());
//		bottomPart.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				okWasClicked();
			}
		});
		bottomPart.add((okButton));
		
		this.add(bottomPart, BorderLayout.SOUTH);
	}
	
	
	
	public static void main(String [] args) {
		
		
		JFrame frame = new JFrame();
		
		NewRoomSetupWizard p = new NewRoomSetupWizard(frame, null);
		
		frame.setContentPane(p);
		
		frame.setMinimumSize(new Dimension(600, 400));
		frame.setMaximumSize(new Dimension(600, 400));
		frame.setPreferredSize(new Dimension(600, 400));
		
		frame.setVisible(true);
		
	}
	
	
	public void cancelWasClicked() {
		
		isCancelled = true;
		encasingFrame.setVisible(false);
		encasingFrame.dispose();
		
	}
	
	public boolean wasCancelled() {
		return isCancelled;
	}
	
	
	
	public void okWasClicked() {
		
		StringBuffer messages = new StringBuffer();
		
		if(this.backgroundField.getText() == null || this.backgroundField.getText().length() == 0) {
			messages.append("You need to pick a background image.\n");
		}
		
		if(this.foregroundField.getText() == null || this.foregroundField.getText().length() == 0) {
			messages.append("You need to pick a foreground image.\n");
		}
		
		if(this.tileWidthField.getText() == null) {
			messages.append("You need to provide a number for the tile width.\n");
		} else {
			try {
				Integer.parseInt(tileWidthField.getText().trim());
			} catch (NumberFormatException e) {
				messages.append("You need to provide a number for the tile width.\n");
			}
		}
		
		if(this.tileHeightField.getText() == null) {
			messages.append("You need to provide a number for the tile height.\n");
		} else {
			try {
				Integer.parseInt(tileHeightField.getText().trim());
			} catch (NumberFormatException e) {
				messages.append("You need to provide a number for the tile height.\n");
			}
		}
		
		
		
		if(this.roomWidthField.getText() == null) {
			messages.append("You need to provide a number for the room width.\n");
		} else {
			try {
				Integer.parseInt(roomWidthField.getText().trim());
			} catch (NumberFormatException e) {
				messages.append("You need to provide a number for the room width.\n");
			}
		}
		
		if(this.roomHeightField.getText() == null) {
			messages.append("You need to provide a number for the room height.\n");
		} else {
			try {
				Integer.parseInt(roomHeightField.getText().trim());
			} catch (NumberFormatException e) {
				messages.append("You need to provide a number for the room height.\n");
			}
		}
		
		if(this.unusedColor.getColor() == null) {
			messages.append("You need to select an unused color.\n");
		}
		
		if(this.transparentColor.getColor() == null) {
			messages.append("You need to select a transparent color.\n");
		}
		
		if(this.outOfBoundsColor.getColor() == null) {
			messages.append("You need to select an out-of-bounds color.\n");
		}
		
		if(this.nameField.getText() == null || this.nameField.getText().length() == 0) {
			messages.append("You need to give the room a name.\n");
		}
		
		if(mainPanel != null && ! mainPanel.validateRoomName(oldName, this.nameField.getText())) {
			messages.append("The name you gave the room is already taken; choose another name.\n");
		} else {
//			System.out.println("mainPanel was null? " + (mainPanel == null));
		}
		
//		System.out.println("hello hello hello");
		
		if(messages.length() > 0) {
			
			JOptionPane.showMessageDialog(this, "Not all fields are valid:\n\n" + messages.toString(), "Error occurred", JOptionPane.ERROR_MESSAGE);
			
		} else {

			tileWidth = Integer.parseInt(tileWidthField.getText());
			tileHeight = Integer.parseInt(tileHeightField.getText());
			
			roomWidth = Integer.parseInt(roomWidthField.getText());
			roomHeight = Integer.parseInt(roomHeightField.getText());
			
			backgroundImageName = backgroundField.getText();
			foregroundImageName = foregroundField.getText();
			
			encasingFrame.setVisible(false);
			encasingFrame.dispose();
			
			roomName = nameField.getText();
			
			if(roomPanel != null) {
				roomPanel.getListItem().setName(roomName);
				if(roomPanel.getFrame() != null) {
					roomPanel.getFrame().setTitle(roomName);
				}
				mainPanel.repaint();
			}
			
			isCancelled = false;
			
		}
		
		
	}
	
	
	
	public static void retrieveImageFile(JTextField textArea, Window theEncasingFrame) {
		
		
		FileDialog fd = null;
		
		if(theEncasingFrame instanceof JDialog) {
			fd = new FileDialog((JDialog) theEncasingFrame, "Select Image File", FileDialog.LOAD);
		} else {
			fd = new FileDialog((JFrame) theEncasingFrame, "Select Image File", FileDialog.LOAD);
		}
		fd.setModal(true);
		
//		System.out.println("about to set visible to true!");
		
		fd.setVisible(true);
		
//		System.out.println("just set visible to true!");
		
		if(fd.getDirectory() != null && fd.getFile() != null) {
			textArea.setEditable(true);
			textArea.setText(fd.getDirectory() + fd.getFile());
			textArea.setEditable(false);
			textArea.repaint();
//			System.out.println("just set the text to <<" + fd.getDirectory() + fd.getFile() + ">>");
		}
		
		fd.dispose();
	}
	
	
	
	
	

	
	

	
	
	
	
	public int getTileWidth() {
		return tileWidth;
	}

	public int getTileHeight() {
		return tileHeight;
	}

	public int getRoomWidth() {
		return roomWidth;
	}

	public int getRoomHeight() {
		return roomHeight;
	}



	


	public String getBackgroundImageName() {
		return backgroundImageName;
	}

	public String getForegroundImageName() {
		return foregroundImageName;
	}




	public Color getUnusedColor() {
		return unusedColor.getColor();
	}
	
	public Color getTransparentColor() {
		return transparentColor.getColor();
	}
	
	public Color getOutOfBoundsColor() {
		return outOfBoundsColor.getColor();
	}
	
	public String getRoomName() {
		return roomName;
	}
	
}
